export class entityManager {
    /**
     * Spawns an item anywhere.
     * @param {ItemStack} item - The item that will spawn.
     * @param {{x: number, y: number, z: number}} location - The location that the item will spawn.
     * @param {string} dimension - The dimension which the item will spawn in.
     * @returns The item the is spawning at the appropriate location.
     */
    static spawnItemAnywhere(item, location, dimension) {
        const itemEntity = dimension.spawnItem(item, {
            x: location.x,
            y: 100,
            z: location.z
        });
        itemEntity.teleport(location, {
            dimension: dimension
        });
        return itemEntity;
    }
}